import { BrowserModule } from '@angular/platform-browser';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { NgModule } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { HttpClientModule } from '@angular/common/http';

import { LineChartModule } from '@swimlane/ngx-charts';

import { AppComponent } from './app.component';
import { PlotExampleComponent } from './plot-example/plot-example.component';
import { PlotExampleDynamicComponent } from './plot-example-dynamic/plot-example-dynamic.component';
import { PlotDataService} from './plot-data.service';
import { PlotExampleOptionsComponent } from './plot-example-options/plot-example-options.component';


@NgModule({
  declarations: [
    AppComponent,
    PlotExampleComponent,
    PlotExampleDynamicComponent,
    PlotExampleOptionsComponent
  ],
  imports: [
    BrowserModule,
    BrowserAnimationsModule,
    HttpClientModule,
    FormsModule,
    LineChartModule
  ],
  providers: [PlotDataService],
  bootstrap: [AppComponent]
})
export class AppModule { }
