import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { environment } from '../environments/environment';
import { PlotData2D } from './plot-data';

@Injectable()
export class PlotDataService {

  private apiUrl = environment.apiUrl;

  constructor(private http: HttpClient) { }

  // get 2D PlotData from python api
  get2D(plot: string, options) {
    return this.http.post<PlotData2D>(this.apiUrl + 'plot/' + plot, options);
  }
}
