// generic plot data class
export class PlotData {
    constructor(
        public type: string
    ) { }
}

// 2D data to generate a plot
export class PlotData2D extends PlotData {
    constructor(
        public x: number[],
        public y: number[]
    ) {
        super('2D');
    }

    // convert x, y arrays into the data structure format used by ngx-charts
    public static toNGxChart(data: PlotData2D, name: string) {
        const plotData = {'name': name, 'series': [] };
        for (let i = 0; i < data.x.length; i++) {
            plotData.series.push({'name': data.x[i], 'value': data.y[i]});
        }
        console.log(plotData);
        return plotData;
    }
}
