import { Component, OnInit, AfterViewInit } from '@angular/core';
import { PlotDataService } from '../plot-data.service';
import { PlotData2D } from '../plot-data';

@Component({
  selector: 'app-plot-example-dynamic',
  templateUrl: './plot-example-dynamic.component.html',
  styleUrls: ['./plot-example-dynamic.component.css']
})
export class PlotExampleDynamicComponent implements OnInit, AfterViewInit {

  public plotData = [ ];

  constructor( private plotDataService: PlotDataService) { }

  ngOnInit() {}

  ngAfterViewInit() {
    // load plot data from python
    this.plotDataService.get2D('test1', {}).subscribe( data =>  {
      this.plotData[0] = PlotData2D.toNGxChart(data, 'test');
      console.log(this.plotData);
    });
  }

}
