import { Component, OnInit, AfterViewInit, ChangeDetectorRef } from '@angular/core';
import { PlotDataService } from '../plot-data.service';
import { PlotData2D } from '../plot-data';

@Component({
  selector: 'app-plot-example-options',
  templateUrl: './plot-example-options.component.html',
  styleUrls: ['./plot-example-options.component.css']
})
export class PlotExampleOptionsComponent implements OnInit, AfterViewInit {

  public plotData = [ ];
  public options = {'k': 2};

  constructor(
    private plotDataService: PlotDataService,
    private cdRef: ChangeDetectorRef
  ) { }

  ngOnInit() {
  }

  ngAfterViewInit() {
    this.updatePlot();
  }

  updatePlot() {
    // load plot data from python
    this.plotDataService.get2D('test2', this.options).subscribe( data =>  {
      this.plotData[0] = PlotData2D.toNGxChart(data, 'sin(' + this.options.k + 'x)');
      // notify change detector that the plot should be redrawn
      this.plotData = [ ...this.plotData ];
    });
  }

}
