import { Component, OnInit } from '@angular/core';

@Component({
  selector: 'app-plot-example',
  templateUrl: './plot-example.component.html',
  styleUrls: ['./plot-example.component.css']
})
export class PlotExampleComponent implements OnInit {

  public plotData = [ ];

  constructor() { }

  ngOnInit() {
    // generate data for a sin plot
    this.plotData.push( {'name': 'sin', 'series': [] } );
    for (let i = 0; i <= 100; i++) {
      const x = 4 * Math.PI * i / 100;
      this.plotData[0].series.push( { 'name': x, 'value': Math.sin(x) } );
    }
    // generate data for a cos plot
    this.plotData.push( {'name': 'cos', 'series': [] } );
    for (let i = 0; i <= 100; i++) {
      const x = 4 * Math.PI * i / 100;
      this.plotData[1].series.push( { 'name': x, 'value': Math.cos(x) } );
    }
    console.log(this.plotData);
  }

}
